#include <PalmOS.h>
#include "C:\Documents and Settings\Administrator\Desktop\ProgressBarLib\ProgressBarLib.h"


#define OUR_REQUIERD_PROGRASS_BAR_LIB_VER		ProgressBarLibVer1000

#define TEST_BAR_X		10	//x
#define TEST_BAR_Y		20	//y
#define TEST_BAR_W		140	//width
#define TEST_BAR_H		20	//height
#define TEST_BAR_2_H	8	//height


#define TEST_BAR_TEXT_COLOR_EMPTY	{0,0,0,0}			// 000000
#define TEST_BAR_TEXT_COLOR_FULL	{0,255,255,0}		// FFFF00

#define TEST_BAR_2_TEXT_COLOR_INNER	{0,153,153,255}		// 9999FF
#define TEST_BAR_2_TEXT_COLOR_OUTER	{0,255,255,255}		// FFFFFF

#define TEST_BAR_BAR_EMPTY			{0,255,255,255}		// FFFFFF
#define TEST_BAR_BAR_FULL			{0,0,0,128}			// 000080
#define TEST_BAR_BAR_BORDER			{0,0,0,0}			// 000000

#define TEST_BAR_MIN				0
#define TEST_BAR_MAX				13
#define TEST_VAR_START_VAL			0

#define TEST_STR					"Tap screen 13 times"
#define TEST_STR2					"Bar will be erased in 3 seconds"
#define TEST_STR3					"Done in 1 seconds"


Err progressBarLibOpen(UInt16* ref){
	
	Err e;
	
	e=SysLibLoad(ProgressBarLibType,ProgressBarLibCreator,ref);
	
	return e;
}

void progressBarLibClose(UInt16 ref){
	
	SysLibRemove(ref);
}

typedef struct{
	
	void* drawFunc;
	void* striFunc;
	void* m68kStrFunc;	//if 68k func called us, this is the pointer to the real callback
	
	UInt32 min;
	UInt32 max;
	UInt32 val;
	
	UInt32 style		:2;
	UInt32 sbz			:30;
	
	RGBColorType textEmpty;	//text colors
	RGBColorType textFull;	//text colors
	RectangleType bounds;
	
	union{
		
		struct{
		
			UInt16 emptyBmp;
			UInt16 fullBmp;
		
		}graphical;
		
		struct{
			
			RGBColorType empty;
			RGBColorType full;
			RGBColorType border;
			
		}text;
		
	}grphx;
	
}progressBarType;

UInt32 swap32(UInt32 x){
	
	return ((x & 0xFF000000) >> 24) | ((x & 0x00FF0000) >> 8) | ((x & 0x0000FF00) << 8) | ((x & 0x000000FF) << 24);
	
}

void dispNum(char* caption,UInt32 val){
	
	char x[16];
	
	StrIToA(x,val);
	
	FrmCustomAlert(10024,caption,x,NULL);
}

void progressBarTestNormal(UInt16 ref){
	
	progressBarPtr bar;
	progressBarType* x;
	UInt32 c;
	EventType e;
	UInt32 sb=0,sa=0;
	
	RGBColorType txtE=TEST_BAR_TEXT_COLOR_EMPTY;	//color of text in bar's non-filled area
	RGBColorType txtF=TEST_BAR_TEXT_COLOR_FULL;		//color fo text in bar's filled area
	RGBColorType barE=TEST_BAR_BAR_EMPTY;			//color of bar's empty area
	RGBColorType barF=TEST_BAR_BAR_FULL;			//color of bar's full area
	RGBColorType barB=TEST_BAR_BAR_BORDER;			//color of bar's border
	
	
	bar=ProgressBarCreate(ref,TEST_BAR_X,TEST_BAR_Y,TEST_BAR_W,TEST_BAR_H,pBarStyleColorsAndText,strStdFuncPercent,
								&txtE,&txtF,&barE,&barF,&barB);
	
	
	if(bar){		//bar created
		
		ProgressBarSetValues(ref,bar,TEST_BAR_MIN,TEST_BAR_MAX,TEST_VAR_START_VAL);
		
		WinDrawChars(TEST_STR,StrLen(TEST_STR),0,0);
		
		ProgressBarDraw(ref,bar);
		
		c=TEST_BAR_MIN;
		
		while(c!=TEST_BAR_MAX){
			
			EvtGetEvent(&e,evtWaitForever);
			
			if(e.eType==penUpEvent){
				
				c++;
				ProgressBarUpdate(ref,bar,c,true);
				
			}
		}
		WinEraseChars(TEST_STR,StrLen(TEST_STR),0,0);
		WinDrawChars(TEST_STR2,StrLen(TEST_STR2),0,0);
		SysTaskDelay(300);
		WinEraseChars(TEST_STR2,StrLen(TEST_STR2),0,0);
		ProgressBarErase(ref,bar);
		ProgressBarDestroy(ref,bar);
		WinDrawChars(TEST_STR3,StrLen(TEST_STR3),0,0);
		SysTaskDelay(100);
		WinEraseChars(TEST_STR3,StrLen(TEST_STR3),0,0);
	}
	else{
		
		ErrAlertCustom(0," cannot create bar","progressBarTestNormal:",NULL);
		
	}
}

void progressBarTestCool(UInt16 ref){
	
	progressBarPtr bar;
	progressBarType* x;
	UInt32 c;
	EventType e;
	UInt32 sb=0,sa=0;
	
	RGBColorType txtE=TEST_BAR_2_TEXT_COLOR_OUTER;	//outer color fo cool text
	RGBColorType txtF=TEST_BAR_2_TEXT_COLOR_INNER;	//inner color of cool text
	
	
	bar=ProgressBarCreate(ref,TEST_BAR_X,TEST_BAR_Y,TEST_BAR_W,TEST_BAR_2_H,pBarStyleGraphicsAndCoolText,strStdFuncValMax,
								&txtE,&txtF,(void*)1000,(void*)1001,NULL);
	
	
	if(bar){		//bar created
		
		ProgressBarSetValues(ref,bar,TEST_BAR_MIN,TEST_BAR_MAX,TEST_VAR_START_VAL);
		
		WinDrawChars(TEST_STR,StrLen(TEST_STR),0,0);
		
		ProgressBarDraw(ref,bar);
		
		c=TEST_BAR_MIN;
		
		while(c!=TEST_BAR_MAX){
			
			EvtGetEvent(&e,evtWaitForever);
			
			if(e.eType==penUpEvent){
				
				c++;
				ProgressBarUpdate(ref,bar,c,true);
				
			}
		}
		WinEraseChars(TEST_STR,StrLen(TEST_STR),0,0);
		WinDrawChars(TEST_STR2,StrLen(TEST_STR2),0,0);
		SysTaskDelay(300);
		WinEraseChars(TEST_STR2,StrLen(TEST_STR2),0,0);
		ProgressBarErase(ref,bar);
		ProgressBarDestroy(ref,bar);
		WinDrawChars(TEST_STR3,StrLen(TEST_STR3),0,0);
		SysTaskDelay(100);
		WinEraseChars(TEST_STR3,StrLen(TEST_STR3),0,0);
	}
	else{
		
		ErrAlertCustom(0," cannot create bar","progressBarTestCool:",NULL);
		
	}
}


Boolean textCallback(progressBarPtr p,char* buf,UInt32 min,UInt32 max,UInt32 val,UInt32 percent,UInt32 percentDec){
	
	if(val==TEST_BAR_MAX){
		
		if(max==TEST_BAR_MAX){
			UInt16 ref;
			
			SysLibFind(ProgressBarLibName,&ref);	//guaranteed to suceed;
			
			ProgressBarSetValues(ref,p,min,max+10,val);
			
			ProgressBarDraw(ref,p);
			
			ProgressBarSetValues(ref,p,min,max+10,val);
			
			
			return false;	//cancel draw or we will continue drawing and draw right over the
							//draw we just did in the line above, but with old values
		}
		else{	//the ProgressBarDraw call above will in fact call here, so here we can draw the string we want shown
			
			StrCopy(buf,"You call that taps? 10 more!");
			return true;
			
		}
	}
	else{
		
		StrCopy(buf,"Just ");
		StrIToA(buf+5,max-val);
		StrCat(buf," more taps...");
		return true;
	}
}

void progressBarTestTextCallback(UInt16 ref){
	
	progressBarPtr bar;
	progressBarType* x;
	UInt32 c;
	EventType e;
	UInt32 sb=0,sa=0;
	UInt32 max;
	
	RGBColorType txtE=TEST_BAR_TEXT_COLOR_EMPTY;	//color of text in bar's non-filled area
	RGBColorType txtF=TEST_BAR_TEXT_COLOR_FULL;		//color fo text in bar's filled area
	RGBColorType barE=TEST_BAR_BAR_EMPTY;			//color of bar's empty area
	RGBColorType barF=TEST_BAR_BAR_FULL;			//color of bar's full area
	RGBColorType barB=TEST_BAR_BAR_BORDER;			//color of bar's border
	
	
	bar=ProgressBarCreate(ref,TEST_BAR_X,TEST_BAR_Y,TEST_BAR_W,TEST_BAR_H,pBarStyleColorsAndCoolText,&textCallback,
								&txtE,&txtF,&barE,&barF,&barB);
	
	
	if(bar){		//bar created
		
		ProgressBarSetValues(ref,bar,TEST_BAR_MIN,TEST_BAR_MAX,TEST_VAR_START_VAL);
		
		WinDrawChars(TEST_STR,StrLen(TEST_STR),0,0);
		
		ProgressBarDraw(ref,bar);
		
		c=TEST_BAR_MIN;
		
		while(ProgressBarGetValues(ref,bar,NULL,&max,NULL),c!=max){
			
			EvtGetEvent(&e,evtWaitForever);
			
			if(e.eType==penUpEvent){
				
				c++;
				ProgressBarUpdate(ref,bar,c,true);
				
			}
		}
		
		WinEraseChars(TEST_STR,StrLen(TEST_STR),0,0);
		WinDrawChars(TEST_STR2,StrLen(TEST_STR2),0,0);
		SysTaskDelay(300);
		WinEraseChars(TEST_STR2,StrLen(TEST_STR2),0,0);
		ProgressBarErase(ref,bar);
		ProgressBarDestroy(ref,bar);
		WinDrawChars(TEST_STR3,StrLen(TEST_STR3),0,0);
		SysTaskDelay(100);
		WinEraseChars(TEST_STR3,StrLen(TEST_STR3),0,0);
	}
	else{
		
		ErrAlertCustom(0," cannot create bar","progressBarTestNormal:",NULL);
		
	}
}

void progressBarTest(){
	
	UInt16 ref;
	Err e;
	progressBarPtr p;
	
	
	//load the library
	
	e=progressBarLibOpen(&ref);
	
	if(e){
		
		ErrAlertCustom(e,"Error occured while opening the library: ",NULL,NULL);
		return;
		
	}
	
	//check version
	
	if(ProgressBarGetVersion(ref)<OUR_REQUIERD_PROGRASS_BAR_LIB_VER){
		
		ErrAlertCustom(0,"Library too old.",NULL,NULL);
		
	}
	else{	//this version is ok
		
		progressBarTestNormal(ref);
		progressBarTestCool(ref);
		progressBarTestTextCallback(ref);
		
	}
	
	progressBarLibClose(ref);
}




UInt32 PilotMain(UInt16 cmd, MemPtr cmdPBP, UInt16 launchFlags)
{
	
	if(cmd==0){
		
		UInt32 d=16;
		
		WinScreenMode(winScreenModeSet,NULL,NULL,&d,NULL);
		
		progressBarTest();
		
		
	}
	
	return errNone;
}
